<?php

error_reporting(E_ALL  & ~E_NOTICE); 

/*
Setup: 
 
- Upload all the files: this file, the configuration script, and the images) to a single folder on your server
- Create a MySQL database, and add a table to that database.
- Run worshiplive_configure.php and set up the configuration.
- Run the Worship LIVE! software
- Select File:Database:Synchronize, and configure the settings on the right pane of the Synchronize dialog
- Upload some playlists via the appropriate Database menu item, or via the "Upload a new playlist file" link at the bottom of the website.

Enjoy!

=====================================================================
=================== DO NOT EDIT THIS FILE ===========================
===================================================================*/

include "worshiplive_settings.php";

// Define file size limit
$limit_size=100000;

$alert = "";
if (($leaderpassword == "") or ($host == "")) {
  writeheader(": Please configure first");
  print 'You must set a worship leader password and other settings. Please <A HREF="worshiplive_configure.php">configure this script</A> before continuing.';
  print "<P>";
  print "<B>PLEASE NOTE!</B> Posting your music online without a password, even in this text-only format, may expose your church to serious and costly legal actions from music copyright holders. The major music labels, even Christian labels, are aggressively pursuing all forms of copyright infringement. It really is important to secure access to your database to avoid these potential problems.";
  print "</BODY></HTML>";
  exit;
}

$version = "6.2.1";
$checkversion = "60201";

$thisscript = $_SERVER['SERVER_NAME'] . $_SERVER['PHP_SELF'];
if (@$_SERVER['HTTPS']) {
  $thisscript = "https://" . $thisscript;
} else {
  $thisscript = "http://" . $thisscript;
}

mysql_connect($host, $securityusername, $securitypassword) or die("Could not connect to the SQL server. Check your database settings in this script."); 
mysql_select_db($db_name) or die("Could not select database");

$writepermission = false;
$readpermission = false;
$permissioninfo = "no access";

session_start();

if (file_exists("worshiplive_configure.php")) {
  // this is a security risk
  writeheader(": Setup Required");
  print "The Worship LIVE! server has been set up.<P>";
  print "Now, for your database security, you MUST rename the \"worshiplive_configure.php\" file before this script can be used.<P>";
  print "Please do this before trying again.";
  print "</BODY></HTML>";
  exit;
}

if ($_GET['password'] != "") {
  $_POST['password'] = $_GET['password'];
}

/*
writeheader();
print "<HR>Posts: <BR>";
foreach($_POST as $key => $value){
  echo "> $key : $value <BR>";
}

print "<HR>Gets: <BR>";
foreach($_GET as $key => $value){
  echo "> $key : $value <BR>";
}

print "<HR>File: <BR>";
print $_FILES['ufile']['size'] . "<BR>";
print $_FILES['ufile']['name'] . "<BR>";
print file_get_contents($_FILES["ufile"]["tmp_name"]);

print "<HR>Session: <BR>";
print $_SESSION['access'];

exit;
*/

if (empty($_POST['action'])) { // calling directly, not a post...

  if ($_GET['action'] == "logout") {
    if ($_SESSION['access']) {
      $_SESSION['access'] = "";
      session_unset();
      session_destroy();
    }
  }

  // if user tried to log in, first check the password
  if ($_POST['password'] != "") {
    if ($_POST['password'] == $leaderpassword || $_POST['password'] == $userpassword) {
      $_SESSION['access'] = $_POST['password'];
    } // if password was bad, will dump go to the login form
  }
  
  // if password checks good, or session has already been validated, set permissions
  if ($_SESSION['access'] == $userpassword) {
    $writepermission = false; 
    $readpermission = true;
    $permissioninfo = "read-only access";
  }
  if ($_SESSION['access'] == $leaderpassword) {
    $writepermission = true; 
    $readpermission = true;
    $permissioninfo = "full access";
  }

   // if bad pw or login not yet attempted, send login form then exit
  if ($readpermission == false) {
    if ($_SESSION['access']) {
      session_unset();
      session_destroy();
    }
    writeheader(": Please log in");
    print "<P ALIGN=CENTER><FONT SIZE=+2>Worship LIVE! Online Database</FONT></P><HR>";
    print "<form method=post action = " . $thisscript . ">Please enter your database password: " 
      . "<input type=password NAME=password SIZE=32 MAXLENGTH=32><input type=Submit value=\"Log In\"></form>";
    print "<HR><p align=right><a href=\"http://www.worship-live.com\" target=_blank>Worship LIVE!</A> Online <BR>Component (version " . $version . ")</p>";
    print "</BODY></HTML>\n\n";
    exit;
  }

  //=============================================================
  if ($_GET['action'] == "rebuild") {
    writeheader(": Rebuilding descriptions");
    $query = "SELECT `uid`, `filecontents` FROM `" . $playlist_table . "`;"; //  . "` LIMIT 5;";
    print $query . "<HR>\n";
    $sql_query = mysql_query($query);
    $matchcount = mysql_num_rows($sql_query);
    print "$matchcount items selected...<P>\n\n";
    while($row = mysql_fetch_array($sql_query)) {
       $description = description($row[1]);
       $description = mysql_real_escape_string($description);
       $query =  "UPDATE `" . $playlist_table . "` SET `description`='$description' WHERE `uid` = '" .  mysql_real_escape_string($row[0]) . "' LIMIT 1 ;";
       // print $query . "<HR>\n";
       $sql_query2 = mysql_query($query);
       $result = mysql_error();
       print "Updating " . $row[0] . " $result<BR>\n";
    }
    print '<HR>[<A HREF="' . $thisscript . '">Back</A>]'; 
    print "</BODY></HTML>\n\n";
    exit;
  }

  //=============================================================
  if (substr($_GET['action'], 0, 10) == "fileexists") {
    $uid = substr($_GET['action'], 10);
    if ($uid == "") {
      print "0";
      exit;
    }
    $query = "SELECT `title` FROM `" . $playlist_table . "` WHERE `uid` = '" . mysql_real_escape_string($uid) . "';";
    $sql_query = mysql_query($query);
    $matchcount = mysql_num_rows($sql_query);
    if ($matchcount > 0) {
      $row = mysql_fetch_row($sql_query);
      print $row[0]; // "Looked for $uid and found $row[0]; request was " . $_GET['action'] . " and query was $query";
    } else {
      print "0";
    }
    exit;
  }

  //=============================================================
  if (substr($_GET['action'], 0, 11) == "deletefile{") {
    if ($writepermission) {
      $uid = substr($_GET['action'], 10);
      $query = "DELETE FROM `" . $playlist_table . "` WHERE `uid` = '" . mysql_real_escape_string($uid) . "' LIMIT 1;";
      $sql_query = mysql_query($query);
      if (mysql_error() == "") {
        $row = mysql_fetch_row($sql_query);
        $alert = "The file was deleted.";
        // Don't write anything else, and don't exit... the script will continue to output the normal page plus the alert message.
      } else {
        writeheader(": Could Not Delete");
        print "The file was not found.<BR>" . mysql_error() . '<BR>[<A HREF="' . $thisscript . '">Back</A>]'; 
        print "</BODY></HTML>";
        exit;
      }
    } else {
      writeheader(": Could Not Delete");
      print "Not logged in with write permission!";
      print "</BODY></HTML>";
      exit;
    }
  }

  //=============================================================
  if (substr($_GET['action'], 0, 13) == "deletesilent{") {
    if ($writepermission) {
      $uid = substr($_GET['action'], 12);

      $query = "SELECT `title` FROM `" . $playlist_table . "` WHERE `uid` = '" . mysql_real_escape_string($uid) . "';";
      $sql_query = mysql_query($query);
      $matchcount = mysql_num_rows($sql_query);
      if ($matchcount > 0) {
        $row = mysql_fetch_row($sql_query);
        $thistitle = $row[0]; // "Looked for $uid and found $row[0]; request was " . $_GET['action'] . " and query was $query";
      }

      $query = "DELETE FROM `" . $playlist_table . "` WHERE `uid` = '" . mysql_real_escape_string($uid) . "' LIMIT 1;";
      $sql_query = mysql_query($query);
      if (mysql_error() == "") {
        print "Deleted a file: $thistitle";
      } else {
        print "Could not delete a file with GUID $uid.";
      }
    } else {
      print "Incorrect password for delete.";
    }
    exit;
  }

  //=============================================================
  if ($_GET['action'] == "clearall") {
    writeheader(": Confirm deletion");
    if ($writepermission) {
      print "<font color=red><B>Do you REALLY want to clear ALL playlists from the online server?</B></font> ";
      print "This cannot be undone.<P>";
      print '<P>[<A HREF="' . $thisscript . '">NO, go back</A>]';
      print '<P>[<A HREF="' . $thisscript . '?action=confirmclearall">YES, delete all the playlists from this server</A>]';
    } else {
      print "Not logged in with write permission!";
    }
    print "</BODY></HTML>\n\n";
    exit;
  }
  //=============================================================
  if ($_GET['action'] == "confirmclearall") {
    writeheader(": Confirm Clear All Files");
    if ($writepermission) {
      $query = "DELETE FROM `" . $playlist_table . ';';
      $sql_query = mysql_query($query);
      if (mysql_error() == "") {
        print 'Deleted. [<A HREF="' . $thisscript . '">Back</A>]';
      } else {
        print "Error.<BR>" . mysql_error() . '<BR>[<A HREF="' . $thisscript . '">Back</A>]'; 
      } 
    } else {
      print "Not logged in with write permission!";
    }
    print "</BODY></HTML>\n\n";
    exit;
  }

  //=============================================================
  if (substr($_GET['action'], 0, 8) == "getfile{") {
    $uid = substr($_GET['action'], 7);
    returnfile($uid);
    exit;
  }

  //=============================================================
  if ($_GET['action'] == "version") {
    print $checkversion;
    exit;
  }

  //=============================================================
  if (substr($_GET['action'], 0, 9) == "listfiles") {
    $query = "SELECT `uid`, `title`, `description`, `filename`, `datemodified`, `filesize` FROM `" . $playlist_table . "`;";
    $sql_query = mysql_query($query);
    $results = "";
    while($row = mysql_fetch_array($sql_query)) {
      $results .= $row[0] . "\t";
      $results .= $row[1] . "\t";
      $results .= $row[2] . "\t";
      $results .= $row[3] . "\t";
      $results .= date("n/j/y H:i", $row[4]) . "\t";
      $results .= $row[5] . "\r\n";
    }
    print $results;
    exit;
  }

  // ======================================================================
  if (substr($_GET['action'], 0, 9) == "showfile{") {
    $uid = substr($_GET['action'], 8);
    $query = "SELECT `uid`, `title`, `description`, `filecontents`, `filename`, `datemodified` FROM `" . $playlist_table . "` WHERE `uid` = '" .  mysql_real_escape_string($uid) . "';";
    $sql_query = mysql_query($query);
    if (mysql_error() == "") {
      $row = mysql_fetch_row($sql_query);
      $contents = "<PRE>" . urldecode($row[0]) . "</PRE>";
    } else {
      $contents = "NotFound: " . $requesteduid . "<BR>" . $query . "<BR>" . mysql_error();
    }
    $filecontents = $row[3];

    writeheader(": " . $row[1]);
    print "<h1 align=center>" . $row[1] . "</h1>\n";
    print "<div>Last modified: <B>" . date("n/j/y H:i", $row[5]) . "</B></div>\n";
    print "<div>Filename: <B>" . $row[4] . "</B></div>\n<BR>\n";
    print "<div>Description: <B>" . $row[2] . "</B></div>\n";

    // Build a list of the titles
    print "<HR>\n";
    print "<textarea rows=20 cols=96>" . $row[3] . "</textarea>\n";
    print '<P><a href="' . $thisscript . "?action=getfile" . $row[0] . '" target="hiddenIframe"><img src="download.gif" width=16 height=16 alt="Download this playlist file" border=0>Download this playlist file</a>';
    print "</BODY></HTML>\n\n";

  //============= Last ditch... nothing else called, so show files ==================================

  } else {

    $sortlink = "";
    $sortquery = "";
    $sorttype =  mysql_real_escape_string($_GET['sort']);

    $query = "SELECT `uid`, `title`, `description`, `filename`, `datemodified`, `filesize`, `filecontents` FROM `" . $playlist_table . "`";

    if ($_POST['searchterm']) {
      $searchterm = mysql_real_escape_string($_POST['searchterm']);
      $query .= " WHERE `title` LIKE '%$searchterm%' || `filecontents` LIKE '%$searchterm%'";  
    } else {
      if ($sorttype) {
        $sortlink = "&sort=" . $sorttype;
        if (in_array($_GET['sort'], array("title", "description", "filename", "filesize", "datemodified"))) {
          $sortquery = " WHERE `". $sorttype . "` != ''";
          $query .= $sortquery . " ORDER BY `" . $sorttype . "` ASC";
        }
        if (in_array($_GET['sort'], array("-title", "-description", "-filename", "-filesize", "-datemodified"))) {
          $sortquery = " WHERE `". substr($sorttype, 1) . "` != ''";
          $query .= $sortquery . " ORDER BY `" . substr($sorttype, 1) . "` DESC";
        }
      }
    }

    $sql_query = mysql_query("SELECT COUNT(*) AS TOTALFOUND FROM `" . $playlist_table . "`" . $sortquery . ";");
    $matchcount = mysql_result($sql_query, 0, "TOTALFOUND");

    if ($_GET['page']) {
      $pagenum =  mysql_real_escape_string($_GET['page']);
    } else {
      $pagenum = 1;
    }
    $query .= " LIMIT " . (($pagenum-1) * 50) . ", " . (($pagenum-1) * 50 + 50) . ";";
    $sql_query = mysql_query($query);

    $contents = "<form method=post action = " . $thisscript . "><table width=95% cellpadding=2 cellspacing=0 border=0 align=center><tr>";
    $contents .= "<td align=left>" . mysql_error(); // . $query . "<P>";
    $pageindex = "";
    if ($matchcount > 50) {
      for ($j = 1; $j <= $matchcount/50 + 1; $j++) {
        if ($j == $pagenum) {
          $pageindex .= " <SPAN style=\"background-color:yellow\">[$j]</span> ";
        } else {
          $pageindex .= ' [<A HREF="' . $thisscript . '?page=' . $j . $sortlink . '">' . $j . '</A>] ';
        }
      }
    } else {
      $pageindex .= ' [<A HREF="' . $thisscript . '">Page 1</A>] ';
    }
    $contents .= $pageindex . " ($matchcount files)";
    $contents .= "</td>\n";

    $contents .= "<td><input type=text name=searchterm length=25><input type=submit value=\"Search within files\">";
    if ($searchterm) {$contents .= " <SPAN style=\"background-color:yellow\">(showing files matching &quot;$searchterm&quot;)</span>";}
    $contents .= "</td>\n";

    $contents .= '<td align=right>Logged in with ' . $permissioninfo . ' : [<A HREF="' . $thisscript . '?action=logout">Log out</A>]</td></tr></table></form>';
    $contents .= "<HR><table cellpadding=2 cellspacing=0 border=1 align=center width=98%>\n";

    $contents .= "<tr bgcolor=#DDFFDD>" 
         . '<td align=left <!--sorttitle-->Title<BR><A HREF="' . $thisscript 
         . '?sort=title"><img src="downarrow.gif" width=10 height=10 border=0 alt="Down"></A> <A HREF="' . $thisscript 
         . '?sort=-title"><img src="uparrow.gif" width=10 height=10 border=0 alt="Up"></A></td>' . "\n"
         . '<td align=center <!--sortdescription-->Description<BR><A HREF="' . $thisscript 
         . '?sort=description"><img src="downarrow.gif" width=10 height=10 border=0 alt="Down"></A> <A HREF="' 
         . $thisscript . '?sort=-description"><img src="uparrow.gif" width=10 height=10 border=0 alt="Up"></A></td>' . "\n"
         . '<td align=center <!--sortfilename-->Filename<BR><A HREF="' . $thisscript 
         . '?sort=filename"><img src="downarrow.gif" width=10 height=10 border=0 alt="Down"></A> <A HREF="' 
         . $thisscript . '?sort=-filename"><img src="uparrow.gif" width=10 height=10 border=0 alt="Up"></A></td>' . "\n"
         . '<td width=60  align=center <!--sortfilesize-->File size<BR><A HREF="' . $thisscript 
         . '?sort=filesize"><img src="downarrow.gif" width=10 height=10 border=0 alt="Down"></A> <A HREF="'
         . $thisscript . '?sort=-filesize"><img src="uparrow.gif" width=10 height=10 border=0 alt="Up"></A></td>' . "\n"
         . '<td width=85  align=left <!--sortdatemodified-->Modified<BR><A HREF="' . $thisscript
         . '?sort=datemodified"><img src="downarrow.gif" width=10 height=10 border=0 alt="Down"></A> <A HREF="'
         . $thisscript . '?sort=-datemodified"><img src="uparrow.gif" width=10 height=10 border=0 alt="Up"></A></td>' . "\n";
    if ($sorttype) {
      if (substr($sorttype, 0, 1) == "-") {
        $sorttype = substr($sorttype, 1);
        $contents = str_replace("<!--sort" . $sorttype . "--" , 'bgcolor=#FF0000' , $contents);
      } else {
        $contents = str_replace("<!--sort" . $sorttype . "--" , 'bgcolor=#00FF00' , $contents);
      }
    }

    if ($writepermission) {
      $contents .= '<td>[X]</td>';
    }
    $contents .= "</tr>" . "\n";

    $rowtoggle = 1;
    while($row = mysql_fetch_array($sql_query)) {
      $rowtoggle= 1 - $rowtoggle;
      if ($rowtoggle==1) {$bgcolor = "#FFFFFF";} else {$bgcolor="#DDDDFF";}

      $songtitle = $row[1]; if ($songtitle == "") {$songtitle="-";}
        if (substr($songtitle, 0, 1) == " ") {$songtitle = "&nbsp;" . $songtitle;}

      $link = $thisscript . "?action=showfile" . $row[0];
      $link = '<A HREF="' . $link . '" target=_blank onclick="showfile(' . "'" . $link . "'" . '); return false;"><img src="view.gif" width=16 height=16 alt="View this playlist file" border=0>' . $songtitle . '</A>';

      $link = '<a href="' . $thisscript . "?action=getfile" . $row[0] . '" target="hiddenIframe"><img src="download.gif" width=16 height=16 alt="Download this playlist file" border=0></a> ' . $link;

      $contents .= "<tr bgcolor=" . $bgcolor . ">" 
         . "<td align=left  >" . $link .   "&nbsp;</td>\n" 
         . "<td align=left>" . $row[2] . "&nbsp;</td>\n"
         . "<td align=left>" . $row[3] . "&nbsp;</td>\n"
         . "<td align=right>" . number_format($row[5]) . "&nbsp;</td>\n"
         . "<td align=center>" . date("n/j/y H:i", $row[4]) . "&nbsp;</td>\n";

      if ($writepermission) {
        $link = $thisscript . "?action=deletefile" . $row[0];
        $contents .= '<td>[<a onclick="return confirmSubmit()" href="' . $link . '">X</a>]</td>';
      }

      $contents .= "</tr>\n";
    }
    writeheader("");

//print "Magic quotes: " . get_magic_quotes_gpc();
//print "<BR>";

    echo "<table cellpadding=3 cellspacing=0 border=0 width=100%><tr>";
    echo "<td width=120>[ Switch to <a href=\"index.php\">Song list</a> ]</td><td>";
    if ($churchname) {
      echo "<P ALIGN=CENTER><FONT SIZE=+2>" . $churchname . " - Playlist Files</FONT></P>";
    } else {
      echo "<P ALIGN=CENTER><FONT SIZE=+2>Worship LIVE! Online Database</FONT></P>";
    }
    echo "</td><td width=120 align=right><a href=\"http://www.worship-live.com\" target=\"_blank\"><img src=\"wl_logo.gif\" alt=\"Worship LIVE!\" height=25 width=55 border=0></a></td>";
    echo "</tr></table>";
    echo '
      <script language="javascript" type="text/javascript">
        function showsong(link) {
          window.open(link, "showsong","location=0,status=1,scrollbars=1,width=700,height=700,resizable=1");
          return false;
        }
      </script>
    ';

    print $contents;
    print "</table>\n\n";
    print "<HR>";
    print "<table width=95% border=0 cellspacing=0 cellpadding=0 align=center><tr>\n";
    print "<td align=left width=33%> $pageindex &nbsp;</td>\n";
    if ($writepermission) {
      print "<td align=center><a href=\"http://www.simusic.com/checkversion.php?program=WORSHIPLIVESERVER&version=" . $checkversion . "&checker=" . $thisscript . "\" target=_blank>Check for<BR> update</A></td>\n";
    } else {
      print "<td>&nbsp;</td>\n";
    }

    if ($writepermission) {
      print '<td align=center><A HREF="' . $thisscript . '?action=rebuild">Rebuild descriptions<BR>from file contents</A></td>';
      print '<td align=center><A HREF="' . $thisscript . '?action=clearall">Delete ALL<BR>playlists</A></td>';
    }

    print "<td align=right width=25%><a href=\"http://www.worship-live.com\" target=_blank>Worship LIVE!</A> Online <BR>Component (version " . $version . ")</td>\n";

    print "</tr></table>\n";

    if ($writepermission) {
      echo "<BR>";
      echo "<FORM name=\"upform\" ACTION=\"$thisscript\" ENCTYPE=\"multipart/form-data\" METHOD=\"post\" >";
      echo "Upload a new playlist file: ";
      echo "<INPUT TYPE=\"file\" NAME=\"ufile\" size=50>";
      echo "<INPUT TYPE=\"hidden\" NAME=\"action\" VALUE=\"putfile\">";
      echo "<INPUT TYPE=\"submit\" name=\"fname\" VALUE=\"Upload\" onclick=\"return TestFileType(this.form.ufile.value)\"> (maximum file size 100kb)";
      echo " <INPUT TYPE=CHECKBOX NAME=\"overwrite\" value=\"yes\"> Overwrite if duplicate";
      echo "</FORM>";
    }

    print "</BODY></HTML>\n\n";
  }
  exit;

} else {

// ----------------------------------------------------------------------------------------------------
// ------------ working via a POST input, such as from the Worship LIVE! software ---------------------
// ----------------------------------------------------------------------------------------------------

  $contents = "";
  $enteredpassword = "";

  // if user tried to log in, first check the password
  if ($_POST['password'] != "") {
    if ($_POST['password'] == $leaderpassword || $_POST['password'] == $userpassword) {
      $enteredpassword = $_POST['password'];
    }
  } else {
    if ($_SESSION['access'] <> "") {
      $enteredpassword = $_SESSION['access'];
    }
  }
  
  // if password checks good, set permissions
  if ($enteredpassword == $userpassword) {
    $writepermission = false; 
    $readpermission = true;
    $permissioninfo = "read-only access";
  }
  if ($enteredpassword == $leaderpassword) {
    $writepermission = true; 
    $readpermission = true;
    $permissioninfo = "full access";
  }

  if (!$readpermission) {
    $contents = "Failure: The password (" . $_POST['password'] . ") you entered does not allow you to use this server.";
  }

  if ($contents == "") {
    $link = mysql_connect($host, $securityusername, $securitypassword); 
    $contents = "Failure:" . mysql_error();
  }

  if ($contents == "Failure:") { 
    // e.g., there was no mysql error - YES, this looks backwards
    $this_script = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
    switch ($_POST['action']) {
      case "":
        $contents = "Failure: No request";
        break;

      // =============================================================
      case "testserversettings":
        $contents = testserversettings();
        break;

      // =============================================================
      case "getfile":
        $uid = $_POST['guid'];
        returnfile($uid);
        exit;
        break;

      // =============================================================
      case "putfile":
        if ($_FILES["ufile"]["tmp_name"] != "") { 
          // From website ============================================================
          writeheader();
          // a file was submitted from the browser, so retrieve it and use it
          $filename = $_FILES['ufile']['name']; // this is the real filename sent by the browser
          if($file_size >= $limit_size){
            print "Your file was larger than the 100Kb limit.<BR>\n";
            exit;
          }
          $inputfile = file_get_contents ($_FILES["ufile"]["tmp_name"]); // this is a temp file randomish name

          // Extract the GUID
          $guidstart = strpos($inputfile, "GUID={") + 5;
          if ($guidstart > 5) {
            $guidend = strpos($inputfile, "\n", $guidstart + 3) - 1;
            $guid = substr($inputfile, $guidstart, $guidend - $guidstart);
            print "Found and used the playlist identifier GUID from the file: $guid.<P>\n";
          } else {
            $guid = guid();
            print "A new playlist identifier GUID was created for this file.<P>";
          }
          $guid = mysql_real_escape_string($guid); // this should NEVER be necessary, but...

          // extract the title and description
          $titlestart = strpos($inputfile, "PLTitle=") + 8;
          $titleend = strpos($inputfile, "\n", $titlestart + 2) - 1;
          $titletext = substr($inputfile, $titlestart, $titleend - $titlestart);
          $description = description($inputfile);
          $description = mysql_real_escape_string($description);
          $inputfile = mysql_real_escape_string($inputfile);

          // check for duplicates in the table
          $query = "SELECT `title` FROM `" . $playlist_table . "` WHERE `uid` = \"$guid\";";
          $sql_query = mysql_query($query);

          if (mysql_num_rows($sql_query) > 0) { // match found
            if ($_POST['overwrite'] != "yes") {
              $row = mysql_fetch_row($sql_query);
              print "A playlist titled [" . $row[0] . "] with the same playlist file identifier already exists.";
              print " If you intended to overwrite this file, please check the [Overwrite] checkbox and try again.<BR>";
              print '<HR>[<A HREF="' . $thisscript . '">Back</A>]'; 
              exit;
            } else {
              $query =  "UPDATE `" . $playlist_table
                . "` SET `title` = '$titletext', " 
                . "`description`='$description', " 
                . "`filecontents`='$inputfile', " 
                . "`filename`='$filename', " 
                . "`filesize`='" . strlen($inputfile) . "', " 
                . "`datemodified`='" . time() . "'";
              $query .= " WHERE `uid` = '$guid' LIMIT 1 ;";
              print "A file with an identical GUID already exists, and was overwritten at your request.<P>\n";
            }
          } else {
            $query = "INSERT INTO `" . $playlist_table
              . "` (uid, title, description, filecontents, filename, filesize, datemodified)";
            $query .= ' VALUES ("' 
              . $guid . '", "' 
              . $titletext . '", "'
              . $description . '", "' 
              . $inputfile . '", "' 
              . $filename . '", "' 
              . strlen($inputfile) . '", "'
              . time() . '");';
            print "Upload was successful. \n";
          }

          // put the data into the table
          $sql_query = mysql_query($query);
          $result = mysql_error();
          if ($result <> "") {
            print "Failure: The result was:\n\n$result\n\n";
          } else {
            print "Saved as [$filename]. \n";
          }
          print '<HR>[<A HREF="' . $thisscript . '">Back</A>]';
          exit;
          break;
        } else {
          // From WL software ============================================================
          $inputfile = $_POST['filecontents'];
          $filename = $_POST['filename'];
          $guid = $_POST['GUID'];
          $guid = mysql_real_escape_string($guid); // this should NEVER be necessary, but...

          // extract the title and description
          $titlestart = strpos($inputfile, "PLTitle=") + 8;
          $titleend = strpos($inputfile, "\n", $titlestart + 2) - 1;
          $titletext = substr($inputfile, $titlestart, $titleend - $titlestart);
          $description = description($inputfile);
          $description = mysql_real_escape_string($description);
          $inputfile = mysql_real_escape_string($inputfile);

          // assume overwrite, so remove any duplicates in the table
          $query = "DELETE FROM `" . $playlist_table . "` WHERE `uid` = \"$guid\" LIMIT 1;";
          $sql_query = mysql_query($query);
          // build the real query
          $query = "INSERT INTO `" . $playlist_table
            . "` (uid, title, description, filecontents, filename, filesize, datemodified)";
          $query .= ' VALUES ("' 
            . $guid . '", "' 
            . $titletext . '", "'
            . $description . '", "' 
            . $inputfile . '", "' 
            . $filename . '", "' 
            . strlen($inputfile) . '", "'
            . time() . '");';

          // put the data into the table
          $sql_query = mysql_query($query);
          $result = mysql_error();
          if ($result <> "") {
            print "Failure: The file was not saved.\n";
          } else {
            print "Saved as [$filename]. \n";
          }
          exit;
        }
        break;
       
      // ==============================================================
      case "confirmwritepermission":
        if ($writepermission) {
          $contents = "TRUE";
        } else {
          $contents = "FALSE";
        }
        break;
    }
  }
}

function testserversettings() {
  global $contents;
  global $playlist_table, $db_name, $leaderpassword, $userpassword;
  $contents = "+ The server location was correct.\n";
  $contents .= "+ The MySQL username and password were correct.\n";
  $contents .= "+ The MySQL server responded as expected.\n";
  $permission = "- The password (" . $_POST['password'] . ") did NOT match the password set by the administrator; you will be unable to use this online service.\n";
  if ($_POST['password'] == $userpassword) {
    $permission = "+ The password (" . $_POST['password'] . ") gives you read-only access; you will be able to read and download playlists, but NOT to upload or change playlists on the server.\n";
  }
  if ($_POST['password'] == $leaderpassword) {
    $permission = "+ The password (" . $_POST['password'] . ") gives you full access; you will be able to read, download, overwrite and upload playlists.\n";
  }
  $contents .= $permission;

  $contents .= mysql_error();
  $query = 'SELECT `uid` FROM `' . $playlist_table . '` WHERE `filedatetime` > 0;';
  $sql_query = mysql_query($query);
  $contents .= "\n+ There are " . (0 + mysql_num_rows($sql_query)) . " playlist files in the online database (" . $db_name . "/" . $playlist_table . ").\n";

  return $contents;
}

function description($filecontents) {
  // Build a short list of the titles
  $description = "";
    $description = "";
    $items = split("\nStart=", $filecontents);
    $i=0;
    foreach ($items as $item) {
      if (strpos($item, "PLItemType=Song")) {
        $i++;
        $titlestart = strpos($item, "\nTitle=") + 7;
        $titleend = strpos($item, "\n", $titlestart + 6) - 1;
        $titletext = substr($item, $titlestart, $titleend - $titlestart);

        $fnamestart = strpos($item, "\nFileName=", $titleend);
        if ($fnamestart) { // < $titleend + 10) {
          $fnameend = strpos($item, "\n", $fnamestart + 2) - 1;
          $fnametext = substr($item, $fnamestart, $fnameend - $fnamestart);
          $paths = preg_split("[\\\]", $fnametext);
          $itemcount = count($paths);
          $fname = $paths[$itemcount - 2] . "\\" . $paths[$itemcount - 1];
          $description .= "$i: <a href=\"index.php?showfilename=" . urlencode($fname) . "\" target=\"_blank\">$titletext</a>";
        } else {
          $description .= "$i: $titletext";
        }
        $description .= "<BR>\n";

        if ($i > 10) {
          $description .= "<I>(and ";
          $description .= (count($items) - $i);
          $description .= " more items)</I>";
          break;
        }
      } else {
        if (strpos($item, "PLItemType=")) {
          $i++;
          $typeline = substr($item, 14, 20);
          $description .= "$i: " . substr($typeline, 0, strpos($typeline, "\n") - 1);
          if (strpos($item, "PLItemType=Scripture")) {
            $titlestart = strpos($item, "\nFileName=") + 10;
            if ($titlestart) {
              $titleend = strpos($item, "\n", $titlestart + 2) - 1;
              $songtitletext = substr($item, $titlestart, $titleend - $titlestart);
              $description .= ": $songtitletext";
            }
          } else {
            $titlestart = strpos($item, "\nTitle=") + 7;
            if ($titlestart) {
              $titleend = strpos($item, "\n", $titlestart + 2) - 1;
              $songtitletext = substr($item, $titlestart, $titleend - $titlestart);
              $description .= ": $songtitletext";
            }
          }
          $description .= "<BR>\n";

        }
      }
    }
  $description = substr($description, 0, -5); // trim off the last <BR>
  if (strpos($filecontents, "##NEWSONGFILE##")) {
    $description .= "<BR><font color=#00AA00><I>[This file contains embedded song data]</I></font>";
  }
  if (strpos($filecontents, "##MEDIABEGINS##")) {
    $description .= "<BR><font color=#AA0000><I>[This file contains embedded media]</I></font>";
  }
  return $description;
}

function extractheader($filecontents, $varname) {
  $tempdata = substr($filecontents, 0, 900);
  $tempdata = str_replace('%5C', '%5C%5C', $tempdata);
  $thissong = urldecode($tempdata);
  $righthalf = strstr($thissong, '##' . $varname . '=');
  $righthalf = substr($righthalf, 3 + strlen($varname));
  $nextlinestart = strpos($righthalf, "\n");
  $lefthalf = substr($righthalf, 0, $nextlinestart-1);
  return $lefthalf;
}

function guid(){
    if (function_exists('com_create_guid')){
        return com_create_guid();
    }else{
        mt_srand((double)microtime()*10000);//optional for php 4.2.0 and up.
        $charid = strtoupper(md5(uniqid(rand(), true)));
        $hyphen = chr(45);// "-"
        $uuid = chr(123)// "{"
                .substr($charid, 0, 8).$hyphen
                .substr($charid, 8, 4).$hyphen
                .substr($charid,12, 4).$hyphen
                .substr($charid,16, 4).$hyphen
                .substr($charid,20,12)
                .chr(125);// "}"
        return $uuid;
    }
}

function returnfile($uid) {
  global $playlist_table;
  $query = "SELECT `filename`, `filecontents` FROM `" . $playlist_table . "` WHERE `uid`='$uid' LIMIT 1;";
  $sql_query = mysql_query($query);
  $matchcount = mysql_num_rows($sql_query);
  if ($matchcount != 0) {
    $row = mysql_fetch_array($sql_query);
    $filecontents = stripslashes($row[1]);
    $filename = $row[0];

    $start = strpos($filename, "\\");
    $filename = substr($filename, $start);

    header('Content-type: application/text');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    print $filecontents;
  } else {
    writeheader(": $uid Not found");
    print "The requested playlist was not found.<P>Asked for: $uid</BODY></HTML>";
    exit;
  }
  return "";
}

function writeheader($title) {
  global $alert;
  print "<HTML>\n<HEAD>\n  "
    . "<TITLE>Worship LIVE! Playlists $title</TITLE>"
    . '  <LINK REL="SHORTCUT ICON" HREF="favicon.ico">' 
    . '  <link href="main.css" type="text/css" rel="StyleSheet">'
    . "</HEAD>";
    if ($alert == "") {
      print "<BODY>\n";
    } else {
      print "<BODY onload=\"alert('" . $alert . "');\">\n";
    }
  ?>
  <script type="text/JavaScript">
    <!-- 
    function TestFileType(fileName) {
      if (!fileName) return;
      dots = fileName.split(".")
      fileType = "." + dots[dots.length-1];
      if (".ppl".indexOf(fileType) != -1) {
        return true;
      } else {
        alert("Please only upload playlist (*.ppl) files.");
        return false;
      }
    }
    function confirmSubmit() {
      var agree=confirm("Are you sure you wish to delete this file?");
      if (agree)
        return true ;
      else
        return false ;
    }
    -->
  </script>
  <iframe src="javascript:false" name="hiddenIframe" style="display:none"></iframe>
  <?php
}
?>

<HTML>
<HEAD>
<TITLE>Worship LIVE! Online Component</TITLE>
</HEAD>
<BODY>
<?php 
  print substr($contents, 0, 100);
  print "\n\n";
  print '<!--<%RESULTS%>' . $contents . '</%RESULTS%>-->\n\n';
?>
<iframe src="javascript:false" name="hiddenIframe" style="display:none"></iframe>
</BODY></HTML>
